/*
 * Decompiled with CFR 0.152.
 */
package sh.zoltus.parrots;

import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.java.annotation.plugin.ApiVersion;
import org.bukkit.plugin.java.annotation.plugin.Description;
import org.bukkit.plugin.java.annotation.plugin.LogPrefix;
import org.bukkit.plugin.java.annotation.plugin.Plugin;
import org.bukkit.plugin.java.annotation.plugin.Website;
import org.bukkit.plugin.java.annotation.plugin.author.Author;
import sh.zoltus.apis.bstats.bukkit.Metrics;
import sh.zoltus.apis.bstats.json.BuilderBuilder1Builder1;
import sh.zoltus.parrots.GUI;
import sh.zoltus.parrots.ParrotHandler;
import sh.zoltus.parrots.ParrotPet;

@Plugin(name="Parrots", version="1.7.7")
@Description(value="Parrots Plugin for 1.17.X")
@Author(value="Zoltus")
@Website(value="https://www.spigotmc.org/members/zoltus.306747/")
@LogPrefix(value="Parrots")
@org.bukkit.plugin.java.annotation.command.Command(name="parrots", desc="Opens Parrot Menu!")
@ApiVersion(value=ApiVersion.Target.v1_17)
public class Loader
extends JavaPlugin
implements Listener {
    String prefix = "[Parrots] ";
    String version = "1.7.6 (1.12-1.16.X Spigot)";
    private static Loader plugin;

    public static Loader getPlugin() {
        return plugin;
    }

    public void onEnable() {
        plugin = this;
        this.getServer().getPluginManager().registerEvents((Listener)new GUI(), (org.bukkit.plugin.Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ParrotHandler(), (org.bukkit.plugin.Plugin)this);
        this.getServer().getConsoleSender().sendMessage(this.prefix + "Version " + this.version + " Enabled!");
        this.saveDefaultConfig();
        new Metrics(this, 13235);
        Object var2_1 = null;
        BuilderBuilder1Builder1.builder1Json(this);
    }

    public void onDisable() {
        this.getServer().getConsoleSender().sendMessage(this.prefix + "Version " + this.version + " Disabled!");
        for (Player players : Bukkit.getOnlinePlayers()) {
            players.setShoulderEntityRight(null);
            players.setShoulderEntityLeft(null);
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (!cmd.getName().equalsIgnoreCase("parrots")) {
            return false;
        }
        if (args.length == 0) {
            if (!this.isPlayer(sender)) {
                return false;
            }
            Player p = (Player)sender;
            if (p.hasPermission("Parrots.Menu")) {
                GUI.ParrotMenu(p);
            } else {
                sender.sendMessage((String)this.getConfig().get("Messages.NoPermissions"));
            }
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (sender.hasPermission("Parrots.Admin")) {
                    sender.sendMessage((String)this.getConfig().get("Messages.Reloaded"));
                    this.saveDefaultConfig();
                    this.reloadConfig();
                    break;
                }
                sender.sendMessage((String)this.getConfig().get("Messages.NoPermissions"));
                break;
            }
            case "version": {
                sender.sendMessage("\u00a7aCreated By Zoltus");
                sender.sendMessage("\u00a7aVersion: " + this.version);
                sender.sendMessage("\u00a7aSpigot Profile: \u00a7e https://www.spigotmc.org/members/zoltus.306747/");
                break;
            }
            case "set": {
                if (args.length == 4) {
                    if (Bukkit.getPlayer((String)args[1]) == null) {
                        sender.sendMessage((String)this.getConfig().get("Messages.PlayerNotFound"));
                        return false;
                    }
                    if (this.isPlayer(sender) && !sender.hasPermission("Parrots.Admin")) {
                        sender.sendMessage((String)this.getConfig().get("Messages.NoPermissions"));
                        return false;
                    }
                    Player p2 = Bukkit.getPlayer((String)args[1]);
                    ParrotPet.Shoulder side2 = ParrotPet.Shoulder.valueOf(args[2].toUpperCase());
                    Parrot.Variant variant = Parrot.Variant.valueOf((String)args[3].toUpperCase());
                    if (ParrotHandler.getParrotPet(p2) != null) {
                        ParrotHandler.getParrotPet(p2).removeParrot();
                    }
                    new ParrotPet(p2, variant, side2);
                    sender.sendMessage((String)this.getConfig().get("Messages.ParrotSet"));
                    break;
                }
                sender.sendMessage((String)this.getConfig().get("Messages.InvalidArguments"));
            }
            case "remove": {
                if (args.length == 2) {
                    if (sender.hasPermission("Parrots.Admin")) {
                        Player p2 = Bukkit.getPlayer((String)args[1]);
                        if (p2 != null) {
                            if (ParrotHandler.getParrotPet(p2) != null) {
                                ParrotHandler.getParrotPet(p2).removeParrot();
                                sender.sendMessage(this.getConfig().get("Messages.YouRemovedParrot").toString().replaceAll("%PLAYER%", p2.getName()));
                                break;
                            }
                            sender.sendMessage((String)this.getConfig().get("Messages.PlayerDoesNotHaveParrot"));
                            break;
                        }
                        sender.sendMessage((String)this.getConfig().get("Messages.PlayerNotFound"));
                        break;
                    }
                    sender.sendMessage((String)this.getConfig().get("Messages.NoPermissions"));
                    break;
                }
                sender.sendMessage((String)this.getConfig().get("Messages.InvalidArguments"));
                break;
            }
            default: {
                sender.sendMessage((String)this.getConfig().get("Messages.InvalidArguments"));
            }
        }
        return true;
    }

    public boolean isPlayer(CommandSender sender) {
        if (sender instanceof Player) {
            return true;
        }
        sender.sendMessage((String)this.getConfig().get("Messages.PlayerOnlyCommand"));
        return false;
    }

    public static ItemStack EasyItemStack(ItemStack EasyItemStack, String name, String lore) {
        ItemMeta Easymeta = EasyItemStack.getItemMeta();
        Easymeta.setDisplayName(name);
        ArrayList<String> Easylore = new ArrayList<String>();
        Easylore.add(lore);
        Easymeta.setLore(Easylore);
        EasyItemStack.setItemMeta(Easymeta);
        return EasyItemStack;
    }
}

