/*
 * Decompiled with CFR 0.152.
 */
package sh.zoltus.parrots;

import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntitySpawnEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import sh.zoltus.parrots.Loader;
import sh.zoltus.parrots.ParrotPet;

public class ParrotHandler
implements Listener {
    public static final ArrayList<ParrotPet> parrotPets = new ArrayList();

    public static ParrotPet getParrotPet(Player p) {
        for (ParrotPet parrotObj : parrotPets) {
            if (parrotObj.getOwner() != p) continue;
            return parrotObj;
        }
        return null;
    }

    public static void removeParrot(Player p) {
        ParrotPet pp = ParrotHandler.getParrotPet(p);
        parrotPets.remove(pp);
        p.setShoulderEntityRight(null);
        p.setShoulderEntityLeft(null);
    }

    public static void updateParrot(Player p, Parrot.Variant variant) {
        ParrotPet pp = ParrotHandler.getParrotPet(p);
        if (pp == null) {
            new ParrotPet(p, variant, ParrotPet.Shoulder.valueOf(Loader.getPlugin().getConfig().get("Config.DefaultSide").toString().toUpperCase()));
        } else {
            pp.setVariant(variant);
            pp.removeParrot();
            new ParrotPet(p, variant, pp.getShoulder());
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void parrotSpawnEvent(EntitySpawnEvent e) {
        Entity entity = e.getEntity();
        for (Player players : Bukkit.getOnlinePlayers()) {
            if (entity.getType() != EntityType.PARROT || !entity.getName().contains(players.getUniqueId() + "Parrot")) continue;
            e.setCancelled(true);
        }
    }

    public static boolean hasShoulderEntity(Player p) {
        return p.getShoulderEntityLeft() != null || p.getShoulderEntityRight() != null;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onMove(PlayerToggleFlightEvent e) {
        Player p = e.getPlayer();
        ParrotPet pp = ParrotHandler.getParrotPet(p);
        if (pp != null && p.isFlying()) {
            Loader.getPlugin().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Loader.getPlugin(), () -> ParrotHandler.getParrotPet(p).setParrot(), 4L);
        }
    }
}

